% SETUP
tStart = tic;
max_iterate = 5;
num_frank_wolfe = 10;
secs_per_minute = 60;
max_swap = Inf;
diary('winning.log');
src_dir = pwd;
csv_dir = [src_dir(1:end-3) 'csv'];
addpath(csv_dir);

% READ IN CONNECTOMES
fprintf(1,'%% Loading connectomes ... ');
A = read_connectome('male_connectome_graph.csv');
B = read_connectome('female_connectome_graph.csv');
fprintf(1,'%3.1f sec.\n',toc(tStart));

% WARM START
fprintf(1,'%% Initializing at submission benchmark.\n');
Pm = read_solution('vnc_matching_submission_benchmark_5154247.csv');

% ALTERNATE
for iter=1:max_iterate
  [~,Pm] = do_frank_wolfe(Pm,A,B,num_frank_wolfe);
  Pm = greedy_search(Pm,A,B,max_swap);
end

% SAVE SOLUTION
scoreP = full(sum(min(A*Pm,Pm*B),'all'));
filename = sprintf('vnc_matching_submission_%07d.csv',scoreP);
save_solution(filename,Pm);

% DONE
tMin = toc(tStart)/secs_per_minute;
fprintf('%%\n%% Total elapsed time is %.1f minutes.\n',tMin);
rmpath(csv_dir);
diary off;